local function HeaderLine(name)
	return Def.ActorFrame {
		Def.Quad {
			InitCommand=cmd(horizalign,left;y,10;zoomto,300,1;x,32;fadeleft,12/300;faderight,64/300);
		};
		LoadFont("Common Normal") .. {
			Text=name;
			InitCommand=cmd(horizalign,left;x,32;NoStroke;shadowlength,1;diffusebottomedge,0.5,0.5,0.5,1);
		};
	};
end
local function PersonLine(name)
	return Def.ActorFrame {
		LoadFont("Common Normal") .. {
			Text=name;
			InitCommand=cmd(horizalign,left;x,52;zoom,0.75;NoStroke;shadowlength,1);
		};
	};
end

local function BlankLine()
	return Def.ActorFrame {
		LoadFont("Common Normal") .. {
			Text="";
			InitCommand=cmd(horizalign,left;x,52;zoom,0.75;NoStroke;shadowlength,1);
		};
	};
end;

local t = Def.ActorScroller {
	SecondsPerItem = 0.30;
	NumItemsToDraw = 40;
	TransformFunction = function( self, offset, itemIndex, numItems)
		self:y((24*offset)-20)
	end;
	BeginCommand = cmd(scrollwithpadding,12,0);
};

t[#t+1] = HeaderLine("Ported by the spinal shark collective");
t[#t+1] = PersonLine("AJ 187");
t[#t+1] = PersonLine("Midiman");
t[#t+1] = PersonLine("shakesoda");

t[#t+1] = BlankLine();

t[#t+1] = HeaderLine("--Original Version--");
t[#t+1] = HeaderLine("Main Support");
t[#t+1] = PersonLine("AJ 187 - Code & Support");
t[#t+1] = PersonLine("shakesoda - Graphics & Support");
t[#t+1] = PersonLine("KeithD - Music, Sound Effects & Support");
t[#t+1] = BlankLine();
t[#t+1] = HeaderLine("Additional Support");
t[#t+1] = PersonLine("Azure - Logo Graphics & Support");
t[#t+1] = BlankLine();
t[#t+1] = HeaderLine("Thanks to ... ");
t[#t+1] = PersonLine("#shakesoda");
t[#t+1] = PersonLine("Spinal Shark Collective");
t[#t+1] = PersonLine("StepMania Team");

return t;
